% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/swmpr_organize.R
\name{comb}
\alias{comb}
\alias{comb.default}
\alias{comb.swmpr}
\title{Combine swmpr data}
\usage{
comb(...)

\method{comb}{swmpr}(..., timestep = 15, differ = timestep/2,
  method = "union")

\method{comb}{default}(..., date_col, timestep = 15, differ = timestep/2,
  method = "union")
}
\arguments{
\item{...}{input time series data objects, from one to many}

\item{timestep}{numeric value of time step to use in minutes, passed to \code{setstep}}

\item{differ}{numeric value defining buffer for merging time stamps to standardized time series, passed to \code{setstep}}

\item{method}{chr string indicating method of combining data.  Use \code{'union'} for all dates as continuous time series or \code{'intersect'} for only areas of overlap. If input is a  \code{swmpr} object, a \code{'station'} name can be used to combine by the date range of a given station, assuming there is overlap with the second station.  A numeric value can be supplied for the default method that specifies which data object to use for the date range based on order of execution in the function call.}

\item{date_col}{chr string indicating name of the date column}
}
\value{
Returns a combined swmpr object
}
\description{
Combine swmpr data types for a station by common time series
}
\details{
The \code{comb} function is used to combine multiple swmpr objects into a single object with a continuous time series at a given step. The \code{timestep} function is used internally such that \code{timestep} and \code{differ} are accepted arguments for \code{comb}.

The function requires one or more swmpr objects as input as separate, undefined arguments. The remaining arguments must be called explicitly since an arbitrary number of objects can be used as input. In general, the function combines data by creating a master time series that is used to iteratively merge all swmpr objects. The time series for merging depends on the value passed to the \code{method} argument. Passing \code{'union'} to \code{method} will create a time series that is continuous starting from the earliest date and the latest date for all input objects. Passing \code{'intersect'} to \code{method} will create a time series that is continuous from the set of dates that are shared between all input objects. Finally, a seven or eight character station name passed to \code{method} will merge all input objects based on a continuous time series for the given station. The specified station must be present in the input data. Currently, combining data types from different stations is not possible, excluding weather data which are typically at a single, dedicated station.
}
\examples{
## get wq and met data as separate objects for the same station
swmp1 <- apacpnut
swmp2 <- apaebmet

## combine nuts and wq data by union, set timestep to 120 minutes
\dontrun{
comb(swmp1, swmp2, timestep = 120, method = 'union')
}
}
\seealso{
\code{\link{setstep}}
}
\concept{
organize

organize

organize
}

