% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annual_range.R
\name{annual_range}
\alias{annual_range}
\alias{annual_range.swmpr}
\title{Annual Range Timeseries}
\usage{
annual_range(swmpr_in, ...)

\method{annual_range}{swmpr}(swmpr_in, param = NULL, target_yr = NULL,
  criteria = NULL, log_trans = FALSE, converted = FALSE,
  criteria_lab = "WQ Threshold", plot_title = FALSE, plot = TRUE, ...)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods. See \code{\link{assign_season}}}

\item{param}{chr string of variable to plot}

\item{target_yr}{numeric, the target year that should be compared against the historic range. If target year is not specified then the dot will not be plotted.}

\item{criteria}{numeric, a numeric criteria that will be plotted as a horizontal line}

\item{log_trans}{logical, should y-axis be log? Defaults to \code{FALSE}}

\item{converted}{logical, were the units converted from the original units used by CDMO? Defaults to \code{FALSE}. See \code{y_labeler} for details.}

\item{criteria_lab}{chr, label for the threshold criteria defined in \code{criteria}. Defaults to "WQ Threshold"}

\item{plot_title}{logical, should the station name be included as the plot title? Defaults to \code{FALSE}}

\item{plot}{logical, should a plot be returned? Defaults to \code{TRUE}}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object
}
\description{
Assess variability within each season for a single year
}
\details{
This function summarizes average daily values, average daily minimums/maximums, and absolute minimums/maximums across user-defined seasons for a target year (\code{target_yr}).

The user also has the option to add a threshold hold line using the \code{criteria} argument. Typically, this value is a water quality threshold, which is why \code{criteria_lab} defaults to \code{'WQ Threshold'}. However, the user has the option to specify any other type of threshold they wish. when doing so, the value for \code{criteria_lab} should be changed accordingly.
}
\examples{
\dontshow{
data(apacpwq)

dat <- qaqc(apacpwq, qaqc_keep = c('0', '3', '5'))

y <- annual_range(dat, param = 'do_mgl', target_yr = 2012)
}

\dontrun{
## get data, prep
data(elksmwq)
dat <- elksmwq

dat <- qaqc(elksmwq, qaqc_keep = c('0', '3', '5'))
do_plt <- annual_range(dat, param = 'do_mgl', target_yr = 2012)
do_plt <- annual_range(dat, param = 'do_mgl', target_yr = 2012, criteria = 2)
}
}
\seealso{
\code{\link[ggplot2]{ggplot}}, \code{\link{assign_season}}, \code{\link{y_labeler}}
}
\author{
Julie Padilla
}
\concept{
analyze

analyze
}
