% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_sk_national_ft_reserves.R
\name{create_sk_national_ft_reserves}
\alias{create_sk_national_ft_reserves}
\title{Create a Flextable Object of Reserve Names}
\usage{
create_sk_national_ft_reserves(sk_result, font_sz_stn = 8,
  font_sz_head = 8, ht_head = 0.75, ht_body = 0.2)
}
\arguments{
\item{sk_result}{a \code{data.frame} of reformatted results from \code{\link{sk_seasonal}}}

\item{font_sz_stn}{int, specify the font size of displayed station names}

\item{font_sz_head}{int, specify the font size of the table header row}

\item{ht_head}{num, specify the cell height of the table body rows. Units for this parameter are in inches.}

\item{ht_body}{num, specify the cell height of the table header row. Units for this parameter are in inches.}
}
\value{
Returns a \code{\link[flextable]{flextable}} object
}
\description{
Create a \code{\link[flextable]{flextable}} of reserve names for use with the NERRS national level template.
}
\details{
This function is intended for internal use with the NERRS national level reporting scripts. Using results from the reserve level trend analyses, \code{create_sk_national_ft_reserves} creates a \code{flextable} object of reserve names for display in the NERRS national level template.
}
\author{
Julie Padilla
}
\concept{reporting}
