% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{slice}
\alias{slice}
\title{Slice a vector}
\usage{
slice(x, by = 2, pattern = NULL)
}
\arguments{
\item{x}{A numeric vector}

\item{by}{The number by which to split the vector}

\item{pattern}{The number of blocks}
}
\description{
Break up a vector by certain N sized chunks.
}
\details{


When using \code{pattern}, the formule used to break the vector is \code{length(x)/pattern)+1}.
}
\examples{
x <- seq(1:15)
slice(x, by = 2)
slice(x, pattern = 4)
slice(sample(x), by= 2) # draw random pairs
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}

