% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/crosstable.R
\encoding{UTF-8}
\name{crosstable}
\alias{crosstable}
\alias{tab}
\title{Cross-tabulation}
\usage{
crosstable(.data, ..., prop = "row", tests = FALSE, deparse.level = 2)

tab(...)
}
\arguments{
\item{.data}{The data.frame.}

\item{prop}{\code{c('row', 'col')} if 'col' column proportions will be
computed; the default is 'row' proportions.}

\item{tests}{A logical whether association tests should be shown below table; default is \code{FALSE}.}

\item{deparse.level}{Integer controlling the construction of labels in the case of non-matrix-like arguments. If 0, middle 2 rownames, if 1, 3 rownames, if 2, 4 rownames (default).}

\item{\dots}{The data paremeters.}
}
\value{
A cross tabulated object. Also can genarate the as latex.
}
\description{
\code{crosstable} produces all possible two-way tabulations of the variables specified.

Cross-tabulation
}
\examples{
crosstable(titanic, SEX, AGE)

 titanic \%>\% tab(SEX, AGE, SURVIVED)

# Agresti (2002), table 3.11, p. 106
# 1992 General Social Survey- Sex and Party affiliation
gss <- data.frame(
   expand.grid(sex=c("female", "male"),
   party=c("dem", "indep", "rep")),
   count=c(279,165,73,47,225,191))

 #Get it expanded
df <- gss[rep(1:nrow(gss), gss[["count"]]), ]

df \%>\% tab(sex, party)

gender = rep(c("female","male"),c(1835,2691))
admitted = rep(c("yes","no","yes","no"),c(557,1278,1198,1493))
dept = rep(c("A","B","C","D","E","F","A","B","C","D","E","F"),
           c(89,17,202,131,94,24,19,8,391,244,299,317))
dept2 = rep(c("A","B","C","D","E","F","A","B","C","D","E","F"),
           c(512,353,120,138,53,22,313,207,205,279,138,351))
department = c(dept,dept2)
ucb = data.frame(gender,admitted,department)
ucb \%>\% tab(admitted, gender)

mytab <- tab(ucb, admitted, gender)

# Output in latex:
summary(mytab, latex = TRUE)
}
\keyword{Descriptive}
\keyword{Stats}
\keyword{Tables}

