% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tabulate.R
\name{tabulate}
\alias{tabulate}
\title{Tabulate}
\usage{
tabulate(x, y, digits = 2)
}
\arguments{
\item{x,y}{The variables for the cross tabulation.}

\item{digits}{The number of digits for rounding proportions.}
}
\description{
\code{tabulate} is a modified version of \code{\link{crosstable}} for printing a summary table with cell counts and column proportions (similar to STATA's
\code{tabulate} \emph{varname1} \emph{varname2}, \code{col}).
}
\examples{
# Agresti (2002), table 3.11, p. 106
# 1992 General Social Survey- Sex and Party affiliation
gss <- data.frame(
   expand.grid(sex=c("female", "male"),
   party=c("dem", "indep", "rep")),
   count=c(279,165,73,47,225,191))

 #Get it expanded
df <- gss[rep(1:nrow(gss), gss[["count"]]), ]

with(df, tabulate(sex, party))

# Agresti (2002), table 3.10, p. 106
# 1992 General Social Survey- Race and Party affiliation
gss <- data.frame(
   expand.grid(Race=c("black", "white"),
   party=c("dem", "indep", "rep")),
   count=c(103,341,15,105,11,405))

df <- gss[rep(1:nrow(gss), gss[["count"]]), ]
with(df, tabulate(Race, party))
}
\seealso{
\code{\link[stats]{xtabs}}, \code{\link{crosstable}},
\code{\link[base]{table}}, \code{\link[base]{prop.table}}
}

