% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\name{calc.CV}
\alias{calc.CV}
\alias{calc.CV.default}
\title{Cramer's V Coefficient for Tables}
\usage{
calc.CV(x, y = NULL, ...)

\method{calc.CV}{default}(x, y = NULL, ...)
}
\arguments{
\item{x}{A vector or a matrix.}

\item{y}{A vector that is ignored if x is a matrix and required if x is a vector.}

\item{\dots}{Extra parameters pass to the \code{\link{table}} function.}
}
\description{
Computes the Cramer's V coefficient of association
 for tables. The Cramer's V is a measure of effect size for a chi-square goodness of fit test.
}
\note{
# Bootstrap confidence intervals for Cramer's V
\url{http://support.sas.com/documentation/cdl/en/statugfreq/63124/PDF/default/statugfreq.pdf}, p. 1821
}
\examples{
# Consider an experiment with two conditions, each with 100 participants.
# Each participant chooses between one of following three parties.

cond1 <- c(40, 25, 35)
cond2 <- c(25, 35, 45)
mat <- cbind(cond1, cond2)
rownames(mat) <- c( 'party1', 'party2', 'party3')

# To test the null hypothesis that the distribution of preferences
# is identical in the two conditions, we run a chi-square test:
stats::chisq.test(mat) # still significant

# However, if we want to estimate the effect size, we then use Cramer's V:
calc.CV(mat)

# Agresti (2002), table 3.10, p. 104
# 1991 General Social Survey: The effect size of race on party identification.
gss <- data.frame(
   expand.grid(race=c("black", "white"),
   party=c("dem", "indep", "rep")),
   count=c(103,341,15,105,11,405))

GSS = untable(gss, freq = "count")

calc.CV(GSS$race, GSS$party)
}
\references{
Agresti, Alan (1996) \emph{Introduction to categorical data
analysis}. NY: John Wiley and Sons.
}
\keyword{Association,}
\keyword{Nominal,}
\keyword{Ordinal}
\keyword{Tests}

