% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\name{calc.TT}
\alias{calc.TT}
\alias{calc.TT.default}
\title{Tschuprow's T for Tables}
\usage{
calc.TT(x, y = NULL)

\method{calc.TT}{default}(x, y = NULL, ...)
}
\arguments{
\item{x}{A vector or a matrix.}

\item{y}{A vector that is ignored if x is a matrix and required if x is a vector.}

\item{\dots}{Extra parameters pass to the \code{\link{table}} function.}
}
\description{
Computes the Tschuprow's T coefficient of association for tables.
}
\details{
Tschuprow's T has the disadvantage of producing an overcorrection. Although kept from being > 1, the correlation coefficient often cannot reach the permissible maximum value of 1. This problem is likely to occur if \code{R} is much greater than \code{C} (or the other way around) in a large \code{R x C} table.
}
\examples{
# some data:
male <- c(33, 76, 6);
female <- c(47, 153, 25);
mat <- cbind( male, female );
rownames(mat) <- c( 'good', 'satisfactory', 'bad');

calc.TT(mat);

# long format
long = untable(mat);

calc.TT(long$Var1, long$Var2)
}
\references{
Tschuprow, A. A. (1939) \emph{Principles of the Mathematical Theory of Correlation}. Translated by M. Kantorowitsch. W. Hodge & Co.
}
\keyword{Tests}

