% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/electoralTool.R
\name{gallagher}
\alias{gallagher}
\title{Gallagher Index}
\usage{
gallagher(v, s, ...)

gallagher(v, s, ...)
}
\arguments{
\item{v}{A numeric vector of data values for votes each political party obtained.}

\item{s}{A numeric vector of data values for seats each political party obtained, the election outcome as seats.}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
A single score (The Gallagher's Representation Score.) given the votes each party received and seats obtained.
}
\description{
Calculates the Gallagher index of LSq index.
}
\details{
The representation score is calculated as: sqrt(sum((Z-R)^2)/2).
}
\examples{
# 2012 Queensland state elecion
pvotes= c(49.65, 26.66, 11.5, 7.53, 3.16, 1.47)
pseats = c(87.64, 7.87, 2.25, 0.00, 2.25, 0.00)

gallagher(pvotes, pseats)
}
\author{
Daniel Marcelino \email{dmarcelino@live.com}
}
\references{
Gallagher, M. (1991) Proportionality, disproportionality and electoral systems. Electoral Studies 10(1):33-51.
}
\seealso{
\code{\link{cox.shugart}}, \code{\link{inv.cox.shugart}}, \code{\link{politicalDiversity}}, \code{\link{grofman}}, \code{\link{farina}},  \code{\link{lijphart}}. For more details see the Indices vignette: \code{vignette("Indices", package = "SciencesPo")}
}

