% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/seatAllocation.R
\encoding{UTF-8}
\name{hamilton}
\alias{hamilton}
\title{The Hamilton Method of Allocating Seats Proportionally}
\usage{
hamilton(parties = NULL, votes = NULL, seats = NULL, ...)

hamilton(parties = NULL, votes = NULL, seats = NULL, ...)
}
\arguments{
\item{parties}{A vector containig parties labels or candidates in the same order of \code{votes}.}

\item{votes}{A vector with the formal votes received by the parties/candidates.}

\item{seats}{An integer for the number of seats to be returned.}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
A \code{data.frame} of length \code{parties} containing apportioned integers (seats) summing to \code{seats}.
}
\description{
Computes the Alexander Hamilton's apportionment method (1792), also known as Hare-Niemeyer method or as Vinton's method. The Hamilton method is a largest-remainder method which uses the Hare Quota.
}
\details{
The Hamilton/Vinton Method sets the divisor as the
proportion of the total population per house seat.
After each state's population is divided by the divisor,
the whole number of the quotient is kept and the fraction
dropped resulting in surplus house seats. Then, the first
surplus seat is assigned to the state with the largest
fraction after the original division. The next is assigned to
the state with the second-largest fraction and so on.
}
\examples{
votes <- sample(1:10000, 5)
parties <- sample(LETTERS, 5)
hamilton(parties, votes, seats = 4)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}
\references{
Lijphart, Arend (1994). \emph{Electoral Systems and Party Systems: A Study of Twenty-Seven Democracies, 1945-1990}. Oxford University Press.
}
\seealso{
\code{\link{dHondt}}, \code{\link{highestAverages}}, \code{\link{largestRemainders}}, \code{\link{politicalDiversity}}.
}

