% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/seatAllocation.R
\encoding{latin1}
\name{highestAverages}
\alias{highestAverages}
\alias{highestAverages.default}
\title{Highest Averages Methods of Allocating Seats Proportionally}
\usage{
highestAverages(parties = NULL, votes = NULL, seats = NULL,
  method = c("dh", "sl", "msl", "danish", "hsl", "hh", "imperiali", "wb",
  "jef", "ad", "hb"), threshold = 0, ...)

\method{highestAverages}{default}(parties = NULL, votes = NULL,
  seats = NULL, method = c("dh", "sl", "msl", "danish", "hsl", "hh",
  "imperiali", "wb", "jef", "ad", "hb"), threshold = 0, ...)
}
\arguments{
\item{parties}{A character vector for parties labels or candidates in the same order as \code{votes}. If \code{NULL}, alphabet will be assigned.}

\item{votes}{A numeric vector for the number of formal votes received by each party or candidate.}

\item{seats}{The number of seats to be filled (scalar or vector).}

\item{method}{A character name for the method to be used. See details.}

\item{threshold}{A numeric value between (0~1). Default is set to 0.}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
A \code{data.frame} of length \code{parties} containing apportioned integers (seats) summing to \code{seats}.
}
\description{
Computes the highest averages method for a variety of formulas of allocating seats proportionally.
}
\details{
The following methods are available:
\itemize{
\item {"dh"}{d'Hondt method}
\item {"sl"}{Sainte-Lague method}
\item {"msl"}{Modified Sainte-Lague method}
\item {"danish"}{Danish modified Sainte-Lague method}
\item {"hsl"}{Hungarian modified Sainte-Lague method}
\item {"imperiali"}{The Italian Imperiali (not to be confused with the Imperiali quota which is a Largest remainder method)}
\item {"hh"}{Huntington-Hill method}
\item {"wb"}{Webster's method}
\item {"jef"}{Jefferson's method}
\item {"ad"}{Adams's method}
\item {"hb"}{Hagenbach-Bischoff method}
}
}
\examples{
# Results for the state legislative house of Ceara (2014):
votes <- c(187906, 326841, 132531, 981096, 2043217, 15061, 103679,109830, 213988, 67145, 278267)

parties <- c("PCdoB", "PDT", "PEN", "PMDB", "PRB", "PSB", "PSC", "PSTU", "PTdoB", "PTC", "PTN")

highestAverages(parties, votes, seats = 42, method = "dh")

# Let's create a data.frame with typical election results
# with the following parties and votes to return 10 seats:

my_election <- data.frame(
party=c("Yellow", "White", "Red", "Green", "Blue", "Pink"),
votes=c(47000, 16000,	15900,	12000,	6000,	3100))

highestAverages(my_election$party,
my_election$votes,
seats = 10,
method="dh")

# How this compares to the Sainte-Lague Method

(dat= highestAverages(my_election$party,
my_election$votes,
seats = 10,
method="sl"))

# Plot it
bar.plot(data=dat, "Party", "Seats") +
theme_fte()
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}
\references{
Gallagher, Michael (1992). "Comparing Proportional Representation
Electoral Systems: Quotas, Thresholds, Paradoxes and Majorities".
\emph{British Journal of Political Science}, 22, 4, 469-496.

 Lijphart, Arend (1994). \emph{Electoral Systems and Party Systems: A Study of Twenty-Seven Democracies, 1945-1990}. Oxford University Press.
}
\seealso{
\code{\link{largestRemainders}}, \code{\link{dHondt}}, \code{\link{hamilton}}, \code{\link{politicalDiversity}}. For more details see the \emph{Indices} vignette: \code{vignette('Indices', package = 'SciencesPo')}.
}
\keyword{Electoral}

