% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/se.R
\encoding{UTF-8}
\name{se}
\alias{se}
\alias{se.data.frame}
\alias{se.default}
\title{Calculates the Standard Error of the Mean}
\usage{
se(x, na.rm = TRUE, ...)

\method{se}{default}(x, na.rm = TRUE, ...)

\method{se}{data.frame}(x, na.rm = TRUE, ...)
}
\arguments{
\item{x}{An \R object.}

\item{na.rm}{A logical value indicating whether \code{NA}
should be stripped before the computation proceeds.
Default is \code{na.rm=TRUE}.}

\item{\dots}{Additional arguements (currently ignored)}
}
\description{
Computes the standard error of the sample mean.
}
\details{
The standard error of the mean (SEM) (\emph{assuming statistical independence of the values in the sample}) is estimated by taking the standard deviation of the population sample, divided by the square root of the sample size: \deqn{se = \frac{{s}}{{\sqrt{n}}}}
}
\examples{
x <- c(1, 2.3, 2, 3, 4, 8, 12, 43, -1,-4)
myse <- sd(x)/sqrt(length(x))
myse
# With the 'se' function:
se(x)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}

