% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Anonymize.R
\encoding{UTF-8}
\name{Anonymize}
\alias{Anonymize}
\alias{Anonymize.default}
\title{To Make Anonymous a Data Frame}
\usage{
Anonymize(.data, col.names = "V", row.names = "")

\method{Anonymize}{default}(.data, col.names = "V", row.names = "")
}
\arguments{
\item{.data}{A vector or a data frame.}

\item{col.names}{A string for column names.}

\item{row.names}{A string for rown names, default is empty.}
}
\value{
An object of the same type as \code{.data}.
}
\description{
Replaces factor and character variables by a
combination of random sampled letters and numbers.
Numeric columns are also transformed, see details.
}
\details{
Strings will is replaced by an algorithm with 52/102 chance of
choosing a letter and 50/102 chance of choosing a number; then it joins
everything in a 5-digits long character string.
}
\examples{
dt <- data.frame(
Z = sample(LETTERS,10),
X = sample(1:10),
Y = sample(c("yes", "no"), 10, replace = TRUE)
)
dt;

Anonymize(dt)

}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}

