% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UTILS.R
\encoding{UTF-8}
\name{Formatted}
\alias{Formatted}
\title{Some Formats for Nicer Display}
\usage{
Formatted(x, style = c("USD", "BRL", "EUR", "Perc"), digits = 2,
  nsmall = 2, decimal.mark = getOption("OutDec"), flag = "")
}
\arguments{
\item{x}{a numeric vector.}

\item{style}{a character name for style. One of "USD", "BRL", "EUR", "Perc".}

\item{digits}{an integer for the number of significant digits to be used for
numeric and complex x}

\item{nsmall}{an integer for the minimum number of digits to the right of
the decimal point.}

\item{decimal.mark}{decimal mark style to be used with Percents (\%), usually (",") or (".").}

\item{flag}{a character string giving a format modifier as "-", "+", "#".}
}
\description{
Some predefined formats for nicer display.
}
\examples{
x <- as.double(c(0.1, 1, 10, 100, 1000, 10000))
Formatted(x)

Formatted(x, "BRL")

Formatted(x, "EUR")

p = c(0.25, 25, 50)

Formatted(p, "Perc", flag="+")

Formatted(p, "Perc", decimal.mark=",")

}

