% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Label.R
\encoding{UTF-8}
\name{Label}
\alias{Label}
\title{Get Variable Label}
\usage{
Label(x, fallback = TRUE, simplify = TRUE)
}
\arguments{
\item{x}{an R object to extract labels from.}

\item{fallback}{a logical indicating if labels should fallback to object name(s). Default is set to \code{TRUE}.}

\item{simplify}{a logical indicating if coerce results to a vector,
otherwise, a list is returned. Default is set to \code{TRUE}.}
}
\description{
This function returns character value previously stored in
variable's label attribute. If none found, and fallback argument is set to
\code{TRUE}, the function returns object's name (retrieved by
deparse(substitute(x))), otherwise \code{NA} is returned with a warning notice.
}
\examples{
 x <- rnorm(100)
Label(x)             # returns "x"

Label(twins$IQb) <- "IQ biological scores"

Label(twins, FALSE)  # returns NA where no labels are found

}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}

