% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Winsorize.R
\encoding{UTF-8}
\name{Winsorize}
\alias{Winsorize}
\title{Winsorized Mean}
\usage{
Winsorize(x, k = 1, na.rm = TRUE)
}
\arguments{
\item{x}{The vector to be winsorized}

\item{k}{An integer for the quantity of outlier elements that to be replaced in the calculation process}

\item{na.rm}{a logical value for \code{na.rm}, default is \code{na.rm=TRUE}.}
}
\value{
An object of the same type as \code{x}
}
\description{
Compute the winsorized mean, which consists of recoding the top k values of a vector.
}
\details{
Winsorizing a vector will produce different results than trimming it. While by trimming a vector causes extreme values to be discarded, by winsorizing it in the other hand, causes extreme values to be replaced by certain percentiles.
}
\references{
Dixon, W. J., and Yuen, K. K. (1999) Trimming and winsorization: A review. \emph{The American Statistician,} \bold{53(3),} 267--269.

Dixon, W. J., and Yuen, K. K. (1960) Simplified Estimation from Censored Normal Samples, \emph{The Annals of Mathematical Statistics,} \bold{31,} 385--391.
 @references  Wilcox, R. R. (2012) \emph{Introduction to robust estimation and hypothesis testing.} Academic Press, 30-32. Statistics Canada (2010) \emph{Survey Methods and Practices.}

 @note One may want to winsorize estimators, however, winsorization tends to be used for one-variable situations.

 @author Daniel Marcelino, \email{dmarcelino@live.com}


 @examples
set.seed(51)  # for reproducibility
x <- rnorm(50)
## introduce outlier
x[1] <- x[1] * 10

# Compare to mean:
 mean(x)
 Winsorize(x)
}
\keyword{Exploratory}

