% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCOREplus.R
\name{SCOREplus}
\alias{SCOREplus}
\title{community detection method called SCORE+}
\usage{
SCOREplus(A, k, c = 0.1, r = NULL)
}
\arguments{
\item{A}{n-by-n binary symmtric adjacency matrix.}

\item{k}{number of communities (>1).}

\item{c}{(optional) tuning parameter for Graph Laplacian, default is 0.1.}

\item{r}{(optional) latent dimension (>1), if not given, chosen between k and k+1 determined by eigen gap}
}
\value{
A list containing \describe{
  \item{label}{Predicted community labels}
  \item{ratios}{n-by-(K-1) or n-by-r ratio matrix.}
  \item{delta}{calculated delta parameter}
  \item{eig.vec}{Top r eigen vectors}
  \item{eig.val}{Top r eigen values}
}
}
\description{
community detection method called SCORE+
}
\examples{
library(igraphdata)
library(igraph)
data('karate')
A = get.adjacency(karate)
karate.plus.out = SCOREplus(A, 2)
karate.plus.out$labels
}
