% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedSCORE.R
\name{mixedSCORE}
\alias{mixedSCORE}
\title{Membership estimation algorithm called mixedSCORE}
\usage{
mixedSCORE(A, K, verbose = F)
}
\arguments{
\item{A}{n-by-n binary symmtric adjacency matrix.}

\item{K}{number of communities.}

\item{verbose}{whether generate message}
}
\value{
A list containing \describe{
  \item{R}{n-by-(K-1) ratio matrix.}
  \item{L}{Selected tunning parameter used for vertex hunting algorithm.}
  \item{thetas}{A vector of the estimated degree heterogeniety parameters}
  \item{vertices}{K-by-(K-1) K vertices of the found convex hull}
  \item{centers}{L-by-(K-1) L centers by kmeans}
  \item{memberships}{n-by-K membership matrix.}
  \item{purity}{A vector of maximum membership of each node}
  \item{hard.cluster.labels}{A vector of integers indicating hard clutering labels, by assigning the node to the cluster with max membership}
}
}
\description{
Membership estimation algorithm called mixedSCORE
}
\examples{
library(igraphdata)
library(igraph)
data('karate')
A = get.adjacency(karate)
karate.mixed.out = mixedSCORE(A, 2)
karate.mixed.out$memberships
}
