% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SettingsObjects.R
\name{createEraCovariateSettings}
\alias{createEraCovariateSettings}
\title{Create era covariate settings}
\usage{
createEraCovariateSettings(
  includeEraIds,
  excludeEraIds = NULL,
  label = "Covariates",
  stratifyById = FALSE,
  start = 0,
  startAnchor = "era start",
  end = 0,
  endAnchor = "era end",
  firstOccurrenceOnly = FALSE,
  allowRegularization = FALSE,
  profileLikelihood = FALSE,
  exposureOfInterest = FALSE,
  preExposure = start < 0
)
}
\arguments{
\item{includeEraIds}{One or more IDs of variables in the \link{SccsData} object that should be
used to construct this covariate. If set to NULL, all
variables will be used.}

\item{excludeEraIds}{One or more IDs of variables in the [SccsData] object that should not
be used to construct this covariate.}

\item{label}{A label used to identify the covariates created using these settings.}

\item{stratifyById}{Should a single covariate be created for every ID in the \link{SccsData}
object, or should a single covariate be constructed? For example, if
the IDs identify exposures to different drugs, should a covariate be
constructed for every drug, or a single covariate for exposure to any
of these drugs. Note that overlap will be considered a single exposure.}

\item{start}{The start of the risk window (in days) relative to the \code{startAnchor}.}

\item{startAnchor}{The anchor point for the start of the risk window. Can be \code{"era start"}
or \code{"era end"}.}

\item{end}{The end of the risk window (in days) relative to the \code{endAnchor}.}

\item{endAnchor}{The anchor point for the end of the risk window. Can be \code{"era start"}
or \code{"era end"}.}

\item{firstOccurrenceOnly}{Should only the first occurrence of the exposure be used?}

\item{allowRegularization}{When fitting the model, should the covariates defined here be allowed
to be regularized?}

\item{profileLikelihood}{When fitting the model, should the likelihood profile be computed for
the covariate defined here? The likelihood profile can be used to
avoid making normal approximations on the likelihood and can be used in
methods specifically designed to make use of the profile, but may take a
while to compute.}

\item{exposureOfInterest}{If TRUE, the fitted coefficient for this variable will be reported when
using \code{\link[=runSccsAnalyses]{runSccsAnalyses()}}. Requires \code{includeEraIds} to be a exposure
reference ID as defined in \code{\link[=createExposure]{createExposure()}}.}

\item{preExposure}{If TRUE, this variable will be used for the pre-exposure diagnostic.}
}
\value{
An object of type \code{EraCovariateSettings}.
}
\description{
Create era covariate settings
}
\details{
Create an object specifying how to create a (set of) era-based covariates.
}
