% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoDestr.R
\name{autoDestr}
\alias{autoDestr}
\title{Automated De-string of Responses}
\usage{
autoDestr(rmat, char = 10)
}
\arguments{
\item{rmat}{Binary response matrix.
A \code{\link[SemNetCleaner]{textcleaner}} filtered response matrix}

\item{char}{Numeric.
Minimum number of characters in a string to be
checked for by \code{\link[SemNetCleaner]{destr}}.
Defaults to \code{10}}
}
\value{
A list containing two objects:

\item{rmat}{A response matrix that has been de-stringed}

\item{string}{A list containing the responses that were de-stringed.
The row number is supplied for each case that was affected.
This can be used to replicate the de-stringing process and to keep track of changes more generally}
}
\description{
Automated de-string responses after performing
\code{\link[SemNetCleaner]{textcleaner}}.
This function is to streamlines the de-stringing of
like responses with other like responses (e.g., "roaches" with "cockroaches")
into one singular function.
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1,2)]

# Clean and prepocess data
clean <- textcleaner(raw, partBY = "row", dictionary = "animals")

# Obtain binary data
bin <- clean$binary

# Change column name as an example
colnames(bin)[1] <- "alpaca.ant.antelope"

# Automated de-string
if(interactive())
{convmat <- autoDestr(bin, 10)}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
