% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SentimentDictionary.R
\name{numPositiveEntries}
\alias{numPositiveEntries}
\title{Number of positive words in dictionary}
\usage{
numPositiveEntries(d)
}
\arguments{
\item{d}{is a dictionary of type \code{\link{SentimentDictionaryBinary}} or
\code{\link{SentimentDictionaryWeighted}}}
}
\description{
Counts total number of positive entries in dictionary.
}
\note{
Entries in \code{\link{SentimentDictionaryWeighted}} with a weight of 0 
are not counted here
}
\examples{
numPositiveEntries(SentimentDictionary(c("increase", "rise", "more"),
                            c("fall", "drop"))) # returns 3
numPositiveEntries(SentimentDictionary(c("increase", "decrease", "exit"),
                               c(+1, -1, -10),
                               rep(NA, 3))) # returns 1
}
\seealso{
\code{\link{numEntries}} and
\code{\link{numNegativeEntries}} for more option to count the number of entries
}
\keyword{dictionary}
