% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{get_adjacency_matrix}
\alias{get_adjacency_matrix}
\title{Get adjacency matrix}
\usage{
get_adjacency_matrix(x, ...)
}
\arguments{
\item{x}{Either a 'network', 'network_module', or 'matrix' object.}

\item{...}{Additional arguments.}
}
\value{
An adjacency matrix with entry ij = 1 if node i and j are 
connected, and 0 otherwise. The diagonal entries are all zero.
}
\description{
The adjacency matrix is constructed from all modules in a network.
}
\note{
The connections in an adjacency matrix and association matrix may differ
if the network contains multiple modules. The adjacency matrix only considers 
direct connections in the network, whereas the association matrix takes into 
account the fact that overlapping modules can create conditional dependencies
between two genes in seperate modules (i.e. genes that don't have a direct
connection in the graph).
}
\examples{
# Create a random network with 10 nodes and add random edge weights.
nw <- random_network(10)
nw <- gen_partial_correlations(nw)
# Get adjacency matrix for the network or individual modules in the network.
get_adjacency_matrix(nw)
module <- nw$modules[[1]]
get_adjacency_matrix(module)
}
