% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_zinb.R
\name{dzinb}
\alias{dzinb}
\title{The Zero-Inflated Negative Binomial Distribution}
\usage{
dzinb(x, size, mu, rho = 0, log = FALSE)
}
\arguments{
\item{x}{A vector of quantities.}

\item{size}{The dispersion paramater used in \code{\link[stats]{dnbinom}}.}

\item{mu}{The mean parameter used in \code{\link[stats]{dnbinom}}.}

\item{rho}{The zero-inflation parameter.}

\item{log}{Logical; if \code{TRUE}, then log(d) is returned.}
}
\value{
The value(s) of the density function evaluated at \code{x}.
}
\description{
The Zero-Inflated Negative Binomial Distribution
}
\examples{
x <- rzinb(10, 1, 10, 0.1)
p <- pzinb(x, 1, 10, 0.1)
y <- qzinb(p, 1, 10, 0.1)
all(x == y)
# Compute P(0 < X < 5) for X ~ ZINB(1, 10, 0.1)
sum(dzinb(0:5, 1, 10, 0.1))
}
