% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference.R
\name{sample_reference_data}
\alias{sample_reference_data}
\title{Sample genes from reference dataset}
\usage{
sample_reference_data(reference_data, p, percent_ZI = NULL,
  threshold_ZI = 0.2)
}
\arguments{
\item{reference_data}{The reference data.frame to use.}

\item{p}{The number of genes (columns) to sample}

\item{percent_ZI}{The percentage of genes to be zero inflated. If
NULL, the genes are sampled at random; in this case, the empirical 
distribution of gene expression profiles will determine the probablility
that a sampled gene is zero inflated.}

\item{threshold_ZI}{The minimum proportion of zero counts for a gene to be
considered as zero inflated.}
}
\description{
Sample genes from reference dataset
}
\examples{
\donttest{
data(reference)
rnaseq <- reference$rnaseq
rnaseq_subset <- sample_reference_data(rnaseq, 10)
}
}
