% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{PCTopCells}
\alias{PCTopCells}
\title{Find cells with highest PCA scores}
\usage{
PCTopCells(object, pc.use = 1, num.cells = NULL, do.balanced = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{pc.use}{Principal component to use}

\item{num.cells}{Number of cells to return}

\item{do.balanced}{Return an equal number of cells with both + and - PC scores.}
}
\value{
Returns a vector of cells
}
\description{
Return a list of genes with the strongest contribution to a set of principal components
}
\examples{
pbmc_small
head(PCTopCells(object = pbmc_small))
# Can specify which dimension and how many cells to return
DimTopCells(object = pbmc_small, dim.use = 2, num.cells = 5)

}
