% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{ProjectPCA}
\alias{ProjectPCA}
\title{Project Principal Components Analysis onto full dataset}
\usage{
ProjectPCA(object, do.print = TRUE, pcs.print = 1:5, pcs.store = 30,
  genes.print = 30, replace.pc = FALSE, do.center = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{do.print}{Print top genes associated with the projected PCs}

\item{pcs.print}{Number of PCs to print genes for}

\item{pcs.store}{Number of PCs to store (default is 30)}

\item{genes.print}{Number of genes with highest/lowest loadings to print for
each PC}

\item{replace.pc}{Replace the existing PCA (overwite
object@dr$pca@gene.loadings), not done by default.}

\item{do.center}{Center the dataset prior to projection (should be set to TRUE)}
}
\value{
Returns Seurat object with the projected PCA values in
object@dr$pca@gene.loadings.full
}
\description{
Takes a pre-computed PCA (typically calculated on a subset of genes) and
projects this onto the entire dataset (all genes). Note that the cell
loadings remains unchanged, but now there are gene loading scores for all
genes.
}
\examples{
pbmc_small
pbmc_small <- ProjectPCA(pbmc_small)
# Vizualize top projected genes in heatmap
PCHeatmap(pbmc_small,pc.use = 1,use.full = TRUE,do.balanced = TRUE)

}
