% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utilities.R
\name{FeatureLocator}
\alias{FeatureLocator}
\title{Feature Locator}
\usage{
FeatureLocator(plot, data.plot, ...)
}
\arguments{
\item{plot}{A ggplot2 plot}

\item{data.plot}{The oridinal data that went into the ggplot2 plot}

\item{...}{Extra parameters, such as dark.theme, recolor, or smooth for using a dark theme,
recoloring based on selected cells, or using a smooth scatterplot, respectively}
}
\value{
The names of the points selected
}
\description{
Select points on a scatterplot and get information about them
}
\examples{
\dontrun{
df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
p <- ggplot(data = df, mapping = aes(x = x, y = y)) + geom_point(mapping = aes(color = 'red'))
FeatureLocator(plot = p, data.plot = df)
}

}
\seealso{
\code{locator}

\code{ggplot2::ggplot_build}
}
