% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{SplitDotPlotGG}
\alias{SplitDotPlotGG}
\title{Split Dot plot visualization}
\usage{
SplitDotPlotGG(object, grouping.var, genes.plot, gene.groups,
  cols.use = c("blue", "red"), col.min = -2.5, col.max = 2.5,
  dot.min = 0, dot.scale = 6, group.by, plot.legend = FALSE,
  do.return = FALSE, x.lab.rot = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{grouping.var}{Grouping variable for splitting the dataset}

\item{genes.plot}{Input vector of genes}

\item{gene.groups}{Add labeling bars to the top of the plot}

\item{cols.use}{colors to plot}

\item{col.min}{Minimum scaled average expression threshold (everything smaller will be set to this)}

\item{col.max}{Maximum scaled average expression threshold (everything larger will be set to this)}

\item{dot.min}{The fraction of cells at which to draw the smallest dot (default is 0.05).}

\item{dot.scale}{Scale the size of the points, similar to cex}

\item{group.by}{Factor to group the cells by}

\item{plot.legend}{plots the legends}

\item{do.return}{Return ggplot2 object}

\item{x.lab.rot}{Rotate x-axis labels}
}
\value{
default, no return, only graphical output. If do.return=TRUE, returns a ggplot2 object
}
\description{
Intuitive way of visualizing how gene expression changes across different identity classes (clusters).
The size of the dot encodes the percentage of cells within a class, while the color encodes the
AverageExpression level of 'expressing' cells. Splits the cells into groups based on a
grouping variable.
Still in BETA
}
\examples{
# Create a simulated grouping variable
pbmc_small@meta.data$groups <- sample(
  x = c("g1", "g2"),
  size = length(x = pbmc_small@cell.names),
  replace = TRUE
)
SplitDotPlotGG(pbmc_small, grouping.var = "groups", genes.plot = pbmc_small@var.genes[1:5])

}
