% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{RidgePlot}
\alias{RidgePlot}
\title{Single cell ridge plot}
\usage{
RidgePlot(object, features, cols = NULL, idents = NULL, sort = FALSE,
  assay = NULL, group.by = NULL, y.max = NULL, same.y.lims = FALSE,
  log = FALSE, ncol = NULL, combine = TRUE, slot = "data", ...)
}
\arguments{
\item{object}{Seurat object}

\item{features}{Features to plot (gene expression, metrics, PC scores,
anything that can be retreived by FetchData)}

\item{cols}{Colors to use for plotting}

\item{idents}{Which classes to include in the plot (default is all)}

\item{sort}{Sort identity classes (on the x-axis) by the average
expression of the attribute being potted, can also pass 'increasing' or 'decreasing' to change sort direction}

\item{assay}{Name of assay to use, defaults to the active assay}

\item{group.by}{Group (color) cells in different ways (for example, orig.ident)}

\item{y.max}{Maximum y axis value}

\item{same.y.lims}{Set all the y-axis limits to the same values}

\item{log}{plot the feature axis on log scale}

\item{ncol}{Number of columns if multiple plots are displayed}

\item{combine}{Combine plots into a single gg object; note that if TRUE; themeing will not work when plotting multiple features}

\item{slot}{Use non-normalized counts data for plotting}

\item{...}{Extra parameters passed on to \code{\link{CombinePlots}}}
}
\value{
A ggplot object
}
\description{
Draws a ridge plot of single cell data (gene expression, metrics, PC
scores, etc.)
}
\examples{
RidgePlot(object = pbmc_small, features = 'PC_1')

}
