% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{LabelPoints}
\alias{LabelPoints}
\alias{Labeler}
\title{Add text labels to a ggplot2 plot}
\usage{
LabelPoints(
  plot,
  points,
  labels = NULL,
  repel = FALSE,
  xnudge = 0.3,
  ynudge = 0.05,
  ...
)
}
\arguments{
\item{plot}{A ggplot2 plot with a GeomPoint layer}

\item{points}{A vector of points to label; if \code{NULL}, will use all points in the plot}

\item{labels}{A vector of labels for the points; if \code{NULL}, will use
rownames of the data provided to the plot at the points selected}

\item{repel}{Use \code{geom_text_repel} to create a nicely-repelled labels; this
is slow when a lot of points are being plotted. If using \code{repel}, set \code{xnudge}
and \code{ynudge} to 0}

\item{xnudge, ynudge}{Amount to nudge X and Y coordinates of labels by}

\item{...}{Extra parameters passed to \code{geom_text}}
}
\value{
A ggplot object
}
\description{
Add text labels to a ggplot2 plot
}
\examples{
data("pbmc_small")
ff <- TopFeatures(object = pbmc_small[['pca']])
cc <- TopCells(object = pbmc_small[['pca']])
plot <- FeatureScatter(object = pbmc_small, feature1 = ff[1], feature2 = ff[2])
LabelPoints(plot = plot, points = cc)

}
\seealso{
\code{\link[ggplot2]{geom_text}}
}
\concept{visualization}
