% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay5.R
\name{dimnames.StdAssay}
\alias{dimnames.StdAssay}
\alias{dimnames<-.StdAssay}
\title{Assay-Level Feature and Cell Names}
\usage{
\method{dimnames}{StdAssay}(x)

\method{dimnames}{StdAssay}(x) <- value
}
\arguments{
\item{x}{An \code{\link{Assay5}} object}

\item{value}{A two-length list with updated feature and/or cells names}
}
\value{
\code{dimnames}: A two-length list with the following values:
\itemize{
 \item A character vector with all features in \code{x}
 \item A character vector with all cells in \code{x}
}

\code{dimnames<-}: \code{x} with the feature and/or cell
names updated to \code{value}
}
\description{
Get and set feature and cell names in v5 Assays
}
\seealso{
\code{\link{Cells}} \code{\link{Features}}

v5 Standard Assay object, validity, and interaction methods
\code{\link{$.StdAssay}()},
\code{\link{.DollarNames.StdAssay}()},
\code{\link{StdAssay-class}},
\code{\link{StdAssay-validity}},
\code{\link{[.StdAssay}()},
\code{\link{[[.StdAssay}()},
\code{\link{dim.StdAssay}()},
\code{\link{show,StdAssay-method}},
\code{\link{split.StdAssay}()},
\code{\link{subset.StdAssay}()}
}
\concept{stdassay}
\keyword{internal}
