% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blis.R
\name{fit_blis}
\alias{fit_blis}
\alias{blis}
\title{Fit Baseline-category Logit Intercept-Slope (BLIS) model on nominal data}
\usage{
fit_blis(Data, key, ...)

blis(Data, key, ...)
}
\arguments{
\item{Data}{\emph{data.frame} or \emph{tibble} with all columns being factors. Support
for \emph{matrix} is limited and behavior not guaranteed.}

\item{key}{A single-column \code{data.frame}, (\strong{not} matrix) \code{tibble} or -
preferably - a factor vector of levels considered as correct responses.}

\item{...}{
  Arguments passed on to \code{\link[mirt:mirt]{mirt::mirt}}
  \describe{
    \item{\code{SE}}{logical; estimate the standard errors by computing the parameter information matrix?
See \code{SE.type} for the type of estimates available}
    \item{\code{covdata}}{a data.frame of data used for latent regression models}
    \item{\code{formula}}{an R formula (or list of formulas) indicating how the latent traits
can be regressed using external covariates in \code{covdata}. If a named list
of formulas is supplied (where the names correspond to the latent trait names in \code{model})
then specific regression effects can be estimated for each factor. Supplying a single formula
will estimate the regression parameters for all latent traits by default}
    \item{\code{SE.type}}{type of estimation method to use for calculating the parameter information matrix
  for computing standard errors and \code{\link[mirt]{wald}} tests. Can be:

  \itemize{
    \item \code{'Richardson'}, \code{'forward'}, or \code{'central'} for the numerical Richardson,
      forward difference, and central difference evaluation of observed Hessian matrix
    \item \code{'crossprod'} and \code{'Louis'} for standard error computations based on the variance of the
      Fisher scores as well as Louis' (1982) exact computation of the observed information matrix.
      Note that Louis' estimates can take a long time to obtain for large sample sizes and long tests
    \item \code{'sandwich'} for the sandwich covariance estimate based on the
      \code{'crossprod'} and \code{'Oakes'} estimates (see Chalmers, 2018, for details)
    \item \code{'sandwich.Louis'} for the sandwich covariance estimate based on the
      \code{'crossprod'} and \code{'Louis'} estimates
    \item \code{'Oakes'} for Oakes' (1999) method using a central difference approximation
      (see Chalmers, 2018, for details)
    \item \code{'SEM'} for the supplemented EM (disables the \code{accelerate} option automatically; EM only)
    \item \code{'Fisher'} for the expected information, \code{'complete'} for information based
      on the complete-data Hessian used in EM algorithm
    \item \code{'MHRM'} and \code{'FMHRM'} for stochastic approximations of observed information matrix
      based on the Robbins-Monro filter or a fixed number of MHRM draws without the RM filter.
      These are the only options supported when \code{method = 'MHRM'}
    \item \code{'numerical'} to obtain the numerical estimate from a call to \code{\link{optim}}
      when \code{method = 'BL'}
 }

  Note that both the \code{'SEM'} method becomes very sensitive if the ML solution has
  has not been reached with sufficient precision, and may be further sensitive
  if the history of the EM cycles is not stable/sufficient for convergence of the respective estimates.
  Increasing the number of iterations (increasing \code{NCYCLES} and decreasing
  \code{TOL}, see below) will help to improve the accuracy, and can be
  run in parallel if a \code{\link[mirt]{mirtCluster}} object has been defined (this will be
  used for Oakes' method as well). Additionally,
  inspecting the symmetry of the ACOV matrix for convergence issues by passing
  \code{technical = list(symmetric = FALSE)} can be helpful to determine if a sufficient
  solution has been reached}
    \item{\code{method}}{a character object specifying the estimation algorithm to be used. The default is
  \code{'EM'}, for the standard EM algorithm with fixed quadrature, \code{'QMCEM'} for
  quasi-Monte Carlo EM estimation, or \code{'MCEM'} for Monte Carlo EM estimation.
  The option \code{'MHRM'} may also be passed to use the MH-RM algorithm,
  \code{'SEM'} for the Stochastic EM algorithm (first
  two stages of the MH-RM stage using an optimizer other than a single Newton-Raphson iteration),
  and \code{'BL'} for the Bock and Lieberman
  approach (generally not recommended for longer tests).

  The \code{'EM'} is generally effective with 1-3 factors, but methods such as the \code{'QMCEM'},
  \code{'MCEM'}, \code{'SEM'}, or \code{'MHRM'} should be used when the dimensions are 3 or more. Note that
  when the optimizer is stochastic the associated \code{SE.type} is automatically changed to
  \code{SE.type = 'MHRM'} by default to avoid the use of quadrature}
    \item{\code{optimizer}}{a character indicating which numerical optimizer to use. By default, the EM
  algorithm will use the \code{'BFGS'} when there are no upper and lower bounds box-constraints and
  \code{'nlminb'} when there are.

  Other options include the Newton-Raphson (\code{'NR'}),
  which can be more efficient than the \code{'BFGS'} but not as stable for more complex
  IRT models (such as the nominal or nested logit models)
  and the related \code{'NR1'} which is also the Newton-Raphson
  but consists of only 1 update that has been coupled with RM Hessian (only
  applicable when the MH-RM algorithm is used). The MH-RM algorithm uses the \code{'NR1'} by default,
  though currently the \code{'BFGS'}, \code{'L-BFGS-B'}, and \code{'NR'}
  are also supported with this method (with
  fewer iterations by default) to emulate stochastic EM updates.
  As well, the \code{'Nelder-Mead'} and \code{'SANN'}
  estimators are available, but their routine use generally is not required or recommended.

  Additionally, estimation subroutines from the \code{Rsolnp} and \code{nloptr}
  packages are available by passing the arguments \code{'solnp'} and \code{'nloptr'},
  respectively. This should be used in conjunction with the \code{solnp_args} and
  \code{nloptr_args} specified below. If equality constraints were specified in the
  model definition only the parameter with the lowest \code{parnum}
  in the \code{pars = 'values'} data.frame is used in the estimation vector passed
  to the objective function, and group hyper-parameters are omitted.
  Equality an inequality functions should be of the form \code{function(p, optim_args)},
  where \code{optim_args} is a list of internally parameters that largely can be ignored
  when defining constraints (though use of \code{browser()} here may be helpful)}
    \item{\code{dentype}}{type of density form to use for the latent trait parameters. Current options include

  \itemize{
    \item \code{'Gaussian'} (default) assumes a multivariate Gaussian distribution with an associated
      mean vector and variance-covariance matrix
    \item \code{'empiricalhist'} or \code{'EH'} estimates latent distribution using an empirical histogram described by
      Bock and Aitkin (1981). Only applicable for unidimensional models estimated with the EM algorithm.
      For this option, the number of cycles, TOL, and quadpts are adjusted accommodate for
      less precision during estimation (namely: \code{TOL = 3e-5}, \code{NCYCLES = 2000}, \code{quadpts = 121})
    \item \code{'empiricalhist_Woods'} or \code{'EHW'} estimates latent distribution using an empirical histogram described by
      Bock and Aitkin (1981), with the same specifications as in \code{dentype = 'empiricalhist'},
      but with the extrapolation-interpolation method described by Woods (2007). NOTE: to improve stability
      in the presence of extreme response styles (i.e., all highest or lowest in each item) the \code{technical} option
      \code{zeroExtreme = TRUE} may be required to down-weight the contribution of these problematic patterns
    \item \code{'Davidian-#'} estimates semi-parametric Davidian curves described by Woods and Lin (2009),
      where the \code{#} placeholder represents the number of Davidian parameters to estimate
      (e.g., \code{'Davidian-6'} will estimate 6 smoothing parameters). By default, the number of
      \code{quadpts} is increased to 121, and this method is only applicable for
      unidimensional models estimated with the EM algorithm
   }}
    \item{\code{constrain}}{a list of user declared equality constraints. To see how to define the
parameters correctly use \code{pars = 'values'} initially to see how the parameters are
labeled. To constrain parameters to be equal create a list with separate concatenated
vectors signifying which parameters to constrain. For example, to set parameters 1 and 5
equal, and also set parameters 2, 6, and 10 equal use
\code{constrain = list(c(1,5), c(2,6,10))}. Constraints can also be specified using the
\code{\link[mirt]{mirt.model}} syntax (recommended)}
    \item{\code{parprior}}{a list of user declared prior item probabilities. To see how to define the
parameters correctly use \code{pars = 'values'} initially to see how the parameters are
labeled. Can define either normal (e.g., intercepts, lower/guessing and upper bounds),
log-normal (e.g., for univariate slopes), or beta prior probabilities.
To specify a prior the form is c('priortype', ...), where normal priors
are \code{parprior = list(c(parnumbers, 'norm', mean, sd))},
\code{parprior = list(c(parnumbers, 'lnorm', log_mean, log_sd))} for log-normal, and
\code{parprior = list(c(parnumbers, 'beta', alpha, beta))} for beta, and
\code{parprior = list(c(parnumbers, 'expbeta', alpha, beta))} for the beta distribution
after applying the function \code{\link{plogis}} to the input value
(note, this is specifically for applying a beta
prior to the lower/upper-bound parameters in 3/4PL models). Priors can also be
specified using \code{\link[mirt]{mirt.model}} syntax (recommended)}
    \item{\code{calcNull}}{logical; calculate the Null model for additional fit statistics (e.g., TLI)?
Only applicable if the data contains no NA's and the data is not overly sparse}
    \item{\code{draws}}{the number of Monte Carlo draws to estimate the log-likelihood for the MH-RM
algorithm. Default is 5000}
    \item{\code{survey.weights}}{a optional numeric vector of survey weights to apply for each case in the
data (EM estimation only). If not specified, all cases are weighted equally (the standard IRT
approach). The sum of the \code{survey.weights} must equal the total sample size for proper
weighting to be applied}
    \item{\code{quadpts}}{number of quadrature points per dimension (must be larger than 2).
By default the number of quadrature uses the following scheme:
\code{switch(as.character(nfact), '1'=61, '2'=31, '3'=15, '4'=9, '5'=7, 3)}.
However, if the method input is set to \code{'QMCEM'} and this argument is left blank then
the default number of quasi-Monte Carlo integration nodes will be set to 5000 in total}
    \item{\code{TOL}}{convergence threshold for EM or MH-RM; defaults are .0001 and .001. If
\code{SE.type = 'SEM'} and this value is not specified, the default is set to \code{1e-5}.
To evaluate the model using only the starting values pass \code{TOL = NaN}, and
to evaluate the starting values without the log-likelihood pass \code{TOL = NA}}
    \item{\code{gpcm_mats}}{a list of matrices specifying how the scoring coefficients in the (generalized)
partial credit model should be constructed. If omitted, the standard gpcm format will be used
(i.e., \code{seq(0, k, by = 1)} for each trait). This input should be used if traits
should be scored different for each category (e.g., \code{matrix(c(0:3, 1,0,0,0), 4, 2)} for a
two-dimensional model where the first trait is scored like a gpcm, but the second trait is only
positively indicated when the first category is selected). Can be used when \code{itemtype}s
are \code{'gpcm'} or \code{'Rasch'}, but only when the respective element in
\code{gpcm_mats} is not \code{NULL}}
    \item{\code{grsm.block}}{an optional numeric vector indicating where the blocking should occur when
using the grsm, NA represents items that do not belong to the grsm block (other items that may
be estimated in the test data). For example, to specify two blocks of 3 with a 2PL item for
the last item: \code{grsm.block = c(rep(1,3), rep(2,3), NA)}. If NULL the all items are assumed
to be within the same group and therefore have the same number of item categories}
    \item{\code{rsm.block}}{same as \code{grsm.block}, but for \code{'rsm'} blocks}
    \item{\code{monopoly.k}}{a vector of values (or a single value to repeated for each item) which indicate
the degree of the monotone polynomial fitted, where the monotone polynomial
corresponds to \code{monopoly.k * 2 + 1} (e.g., \code{monopoly.k = 2} fits a
5th degree polynomial). Default is \code{monopoly.k = 1}, which fits a 3rd degree polynomial}
    \item{\code{large}}{a \code{logical} indicating whether unique response patterns should be obtained prior
  to performing the estimation so as to avoid repeating computations on identical patterns.
  The default \code{TRUE} provides the correct degrees of freedom for the model since all unique patterns
  are tallied (typically only affects goodness of fit statistics such as G2, but also will influence
  nested model comparison methods such as \code{anova(mod1, mod2)}), while \code{FALSE} will use the
  number of rows in \code{data} as a placeholder for the total degrees of freedom. As such, model
  objects should only be compared if all flags were set to \code{TRUE} or all were set to \code{FALSE}

  Alternatively, if the collapse table of frequencies is desired for the purpose of saving computations
  (i.e., only computing the collapsed frequencies for the data onte-time) then a character vector can
  be passed with the arguement \code{large = 'return'} to return a list of all the desired
  table information used by \code{mirt}. This list object can then be reused by passing it back
  into the \code{large} argument to avoid re-tallying the data again
  (again, useful when the dataset are very large and computing the tabulated data is
  computationally burdensome). This strategy is shown below:
  \describe{
  \item{Compute organized data}{e.g., \code{internaldat <- mirt(Science, 1, large = 'return')}}
  \item{Pass the organized data to all estimation functions}{e.g.,
  \code{mod <- mirt(Science, 1, large = internaldat)}}
}}
    \item{\code{GenRandomPars}}{logical; generate random starting values prior to optimization instead of
using the fixed internal starting values?}
    \item{\code{accelerate}}{a character vector indicating the type of acceleration to use. Default
is \code{'Ramsay'}, but may also be \code{'squarem'} for the SQUAREM procedure (specifically,
the gSqS3 approach) described in Varadhan and Roldand (2008).
To disable the acceleration, pass \code{'none'}}
    \item{\code{verbose}}{logical; print observed- (EM) or complete-data (MHRM) log-likelihood
after each iteration cycle? Default is TRUE}
    \item{\code{solnp_args}}{a list of arguments to be passed to the \code{solnp::solnp()} function for
equality constraints, inequality constraints, etc}
    \item{\code{nloptr_args}}{a list of arguments to be passed to the \code{nloptr::nloptr()}
function for equality constraints, inequality constraints, etc}
    \item{\code{spline_args}}{a named list of lists containing information to be passed to the \code{\link{bs}} (default)
  and \code{\link{ns}} for each spline itemtype. Each element must refer to the name of the itemtype with the
  spline, while the internal list names refer to the arguments which are passed. For example, if item 2 were called
  'read2', and item 5 were called 'read5', both of which were of itemtype 'spline' but item 5 should use the
  \code{\link{ns}} form, then a modified list for each input might be of the form:

  \code{spline_args = list(read2 = list(degree = 4),
                           read5 = list(fun = 'ns', knots = c(-2, 2)))}

  This code input changes the \code{bs()} splines function to have a \code{degree = 4} input,
  while the second element changes to the \code{ns()} function with knots set a \code{c(-2, 2)}}
    \item{\code{control}}{a list passed to the respective optimizers (i.e., \code{optim()}, \code{nlminb()},
etc). Additional arguments have been included for the \code{'NR'} optimizer: \code{'tol'}
for the convergence tolerance in the M-step (default is \code{TOL/1000}), while the default
number of iterations for the Newton-Raphson optimizer is 50 (modified with the \code{'maxit'}
control input)}
    \item{\code{technical}}{a list containing lower level technical parameters for estimation. May be:
\describe{
  \item{NCYCLES}{maximum number of EM or MH-RM cycles; defaults are 500 and 2000}
  \item{MAXQUAD}{maximum number of quadratures, which you can increase if you have more than
    4GB or RAM on your PC; default 20000}
  \item{theta_lim}{range of integration grid for each dimension; default is \code{c(-6, 6)}}
  \item{set.seed}{seed number used during estimation. Default is 12345}
  \item{SEtol}{standard error tolerance criteria for the S-EM and MHRM computation of the
    information matrix. Default is 1e-3}
  \item{symmetric}{logical; force S-EM/Oakes information matrix estimates to be symmetric? Default is TRUE
    so that computation of standard errors are more stable. Setting this to FALSE can help
    to detect solutions that have not reached the ML estimate}
  \item{SEM_window}{ratio of values used to define the S-EM window based on the
    observed likelihood differences across EM iterations. The default is
    \code{c(0, 1 - SEtol)}, which provides nearly the very full S-EM window (i.e.,
    nearly all EM cycles used). To use the a smaller SEM window change the window to
    to something like \code{c(.9, .999)} to start at a point farther into the EM history}
  \item{warn}{logical; include warning messages during estimation? Default is TRUE}
  \item{message}{logical; include general messages during estimation? Default is TRUE}
  \item{customK}{a numeric vector used to explicitly declare the number of response
    categories for each item. This should only be used when constructing mirt model for
    reasons other than parameter estimation (such as to obtain factor scores), and requires
    that the input data all have 0 as the lowest category. The format is the same as the
    \code{extract.mirt(mod, 'K')} slot in all converged models}
  \item{customPriorFun}{a custom function used to determine the normalized density for
    integration in the EM algorithm. Must be of the form \code{function(Theta, Etable){...}},
    and return a numeric vector with the same length as number of rows in \code{Theta}. The
    \code{Etable} input contains the aggregated table generated from the current E-step
    computations. For proper integration, the returned vector should sum to
    1 (i.e., normalized). Note that if using the \code{Etable} it will be NULL
    on the first call, therefore the prior will have to deal with this issue accordingly}
  \item{zeroExtreme}{logical; assign extreme response patterns a \code{survey.weight} of 0
    (formally equivalent to removing these data vectors during estimation)?
    When \code{dentype = 'EHW'}, where Woods' extrapolation is utilized,
    this option may be required if the extrapolation causes expected densities to tend towards
    positive or negative infinity. The default is \code{FALSE}}
  \item{customTheta}{a custom \code{Theta} grid, in matrix form, used for integration.
    If not defined, the grid is determined internally based on the number of \code{quadpts}}
  \item{delta}{the deviation term used in numerical estimates when computing the ACOV matrix
    with the 'forward' or 'central' numerical approaches, as well as Oakes' method with the
    Richardson extrapolation. Default is 1e-5}
  \item{parallel}{logical; use the parallel cluster defined by \code{\link[mirt]{mirtCluster}}?
    Default is TRUE}
  \item{internal_constraints}{logical; include the internal constraints when using certain
    IRT models (e.g., 'grsm' itemtype). Disable this if you want to use special optimizers
    such as the solnp. Default is \code{TRUE}}
  \item{gain}{a vector of two values specifying the numerator and exponent
       values for the RM gain function \eqn{(val1 / cycle)^val2}.
       Default is \code{c(0.10, 0.75)}}
  \item{BURNIN}{number of burn in cycles (stage 1) in MH-RM; default is 150}
  \item{SEMCYCLES}{number of SEM cycles (stage 2) in MH-RM; default is 100}
  \item{MHDRAWS}{number of Metropolis-Hasting draws to use in the MH-RM at each iteration; default is 5}
  \item{MHcand}{a vector of values used to tune the MH sampler. Larger values will
    cause the acceptance ratio to decrease. One value is required for each group in
    unconditional item factor analysis (\code{mixedmirt()} requires additional values
    for random effect). If null, these values are determined internally, attempting to
    tune the acceptance of the draws to be between .1 and .4}
  \item{MHRM_SE_draws}{number of fixed draws to use when \code{SE=TRUE} and \code{SE.type = 'FMHRM'}
    and the maximum number of draws when \code{SE.type = 'MHRM'}. Default is 2000}
  \item{MCEM_draws}{a function used to determine the number of quadrature points to draw for the
    \code{'MCEM'} method. Must include one argument which indicates the iteration number of the
    EM cycle. Default is \code{function(cycles) 500 + (cycles - 1)*2}, which starts the number of
    draws at 500 and increases by 2 after each full EM iteration}
  \item{info_if_converged}{logical; compute the information matrix when using the MH-RM algorithm
    only if the model converged within a suitable number of iterations? Default is \code{TRUE}}
  \item{logLik_if_converged}{logical; compute the observed log-likelihood when using the MH-RM algorithm
    only if the model converged within a suitable number of iterations? Default is \code{TRUE}}
  \item{keep_vcov_PD}{logical; attempt to keep the variance-covariance matrix of the latent traits
    positive definite during estimation in the EM algorithm? This generally improves the convergence
    properties when the traits are highly correlated. Default is \code{TRUE}}
}}
  }}
}
\value{
Fitted model of class \linkS4class{BlisClass} (extending standard \code{mirt}'s
\code{SingleGroupClass}).
}
\description{
\code{blis} fits the IRT Nominal Response Model to data from multiple-choice tests,
while accounting for the correct answer and treating this option as a baseline
in this baseline-category logit model. The intercept-slope parametrization in
BLIS can be converted to IRT (difficulty-discrimination) parametrization (BLIRT).
}
\details{
For the details on \code{coef} method dispatched for fitted BLIS model, see
\link{coef,BlisClass-method}. To get more on the class, see \linkS4class{BlisClass}.
}
\examples{
fitted_blis <- fit_blis(HCItest[, 1:20], HCIkey, SE = TRUE)
coef(fitted_blis)
coef(fitted_blis)$`Item 12`
coef(fitted_blis, IRTpars = TRUE)
coef(fitted_blis, IRTpars = TRUE, CI = 0.90) # 90\% CI instead of 95\% CI
coef(fitted_blis, IRTpars = TRUE, printSE = TRUE) # SE instead of CI
}
\seealso{
Other BLIS/BLIRT related: 
\code{\link{BlisClass-class}},
\code{\link{coef,BlisClass-method}},
\code{\link{get_orig_levels}()},
\code{\link{nominal_to_int}()},
\code{\link{obtain_nrm_def}()},
\code{\link{print.blis_coefs}()}
}
\author{
Jan Netik \cr Institute of Computer Science of the Czech Academy of
Sciences \cr \email{netik@cs.cas.cz}

Patricia Martinkova \cr Institute of Computer Science of the Czech Academy
of Sciences \cr \email{martinkova@cs.cas.cz}
}
\concept{BLIS/BLIRT related}
