% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SieveFittingModels.R
\name{GenSamples}
\alias{GenSamples}
\title{Generate some simulation/testing samples with nonlinear truth.}
\usage{
GenSamples(
  s.size,
  xdim = 1,
  x.dis = "uniform",
  x.para = NULL,
  frho = "linear",
  frho.para = 100,
  y.type = "continuous",
  noise.dis = "normal",
  noise.para = 0.5
)
}
\arguments{
\item{s.size}{a number. Sample size.}

\item{xdim}{a number. Dimension of the feature vectors X.}

\item{x.dis}{a string. It specifies the distribution of feature X. The default is uniform distribution over \code{xdim}-dimensional unit cube.}

\item{x.para}{extra parameter to specify the feature distribution.}

\item{frho}{a string. It specifies the true regression/log odds functions used to generate the data set. The default is a linear function.}

\item{frho.para}{extra parameter to specify the true underlying regression/log odds function.}

\item{y.type}{a string. Default is \code{y.type = 'continuous'}, meaning the outcome is numerical and the problem is regression. Set it to \code{y.type = 'binary'} for binary outcome.}

\item{noise.dis}{a string. For the distribution of the noise variable (under regression probelm settings). Default is Gaussian distribution.}

\item{noise.para}{a number. It specifies the magnitude of the noise in regression settings.}
}
\value{
a \code{data.frame}. The variable \code{Y} is the outcome (either continuous or binary). Each of the rest of the variables corresponds to one dimension of the feature vector.
}
\description{
This function is used in several examples in the package.
}
\examples{
xdim <- 1 #1 dimensional feature
#generate 1000 training samples
TrainData <- GenSamples(s.size = 1000, xdim = xdim)
#generate some noise-free testing samples
TestData <- GenSamples(s.size = 1000, xdim = xdim, noise.para = 0)
}
