% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{RMSE}
\alias{RMSE}
\title{Compute the (normalized) root mean square error}
\usage{
RMSE(observed, population = NULL, type = "RMSE")
}
\arguments{
\item{observed}{a numeric vector of parameter estimates, where the length is equal to the number of
  replications}

\item{population}{a numeric scalar indicating the fixed population value. If NULL, then it will be assumed
  that the \code{observed} input is in a deviation form (therefore \code{sqrt(mean(observed^2))} will be
  returned)}

\item{type}{type of deviation to compute. Can be 'RMSE' (default) for the root mean square-error,
  'NRMSE' for the normalized RMSE (RMSE / (max(observed) - min(observed))), or 'CV' for the coefficient of
  variation}
}
\value{
returns a single number indicating the overall average deviation in the estimates
}
\description{
Computes the average deviation (root mean square error; also known as the root mean square deviation)
of a sample estimate from the population value. Accepts observed and population values,
as well as observed values which are in deviation form.
}
\examples{
pop <- 1
samp <- rnorm(100, 1, sd = 0.5)
RMSE(samp, pop)

dev <- samp - pop
RMSE(dev)

RMSE(samp, pop, type = 'NRMSE')
RMSE(dev, type = 'NRMSE')
RMSE(samp, pop, type = 'CV')
}
\seealso{
MAE
}

