% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Serlin2000.R
\name{Serlin2000}
\alias{Serlin2000}
\title{Empirical detection robustness method suggested by Serlin (2000)}
\usage{
Serlin2000(p, alpha, delta, R, CI = 0.95)
}
\arguments{
\item{p}{(optional) a vector containing the empirical detection rate(s) to be tested.
Omitting this input will compute only the CV1 and CV2 values, while including this
input will perform a one-sided hypothesis test for robustness}

\item{alpha}{Type I error rate (e.g., often set to .05)}

\item{delta}{(optional) symmetric robustness interval around \code{alpha} (e.g., a value
of .01 when \code{alpha = .05} would test the robustness window .04-.06)}

\item{R}{number of replications used in the simulation}

\item{CI}{confidence interval for \code{alpha} as a proportion. Default of 0.95
indicates a 95\% interval}
}
\description{
Hypothesis test to determine whether an observed empirical detection rate,
coupled with a given robustness interval, statistically differs from the
population value. Uses the methods described by Serlin (2000) as well to
generate critical values (similar to confidence intervals, but define a fixed
window of robustness). Critical values may be computed without performing the simulation
experiment (hence, can be obtained a priori).
}
\examples{

# Cochran's criteria at alpha = .05 (i.e., 0.5 +- .01), assuming N = 2000
Serlin2000(p = .051, alpha = .05, delta = .01, R = 2000)

# Bradley's liberal criteria given p = .06 and .076, assuming N = 1000
Serlin2000(p = .060, alpha = .05, delta = .025, R = 1000)
Serlin2000(p = .076, alpha = .05, delta = .025, R = 1000)

# multiple p-values
Serlin2000(p = c(.05, .06, .07), alpha = .05, delta = .025, R = 1000)

# CV values computed before simulation performed
Serlin2000(alpha = .05, R = 2500)

}
\references{
Serlin, R. C. (2000). Testing for Robustness in Monte Carlo Studies.
\emph{Psychological Methods, 5}, 230-240.

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
