% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.B.accurate.R
\name{is.B.accurate}
\alias{is.B.accurate}
\title{Verification of B accuracy}
\usage{
is.B.accurate(B_fun, n_fun, correl_fun)
}
\arguments{
\item{B_fun}{Numeric vector of global co-regulation coefficients}

\item{n_fun}{Number of enzymes in the system}

\item{correl_fun}{Character string indicating the constraint applied on the system}
}
\value{
Return \code{TRUE} if all conditions are respected, else stop
}
\description{
Verifies if the vector \code{B_fun} of global co-regulation coefficients is accurate for other functions
}
\details{
Different tests are performed on parameter \code{B_fun} to verify its accuracy.

\itemize{
   \item Is there regulation? If yes, \code{B_fun} is necessary.
   \item Do \code{B_fun} have a correct length? Compare \code{length(B_fun)} and number of enzymes \code{n_fun}. If difference, stops.
   \item Is there negative regulation in \code{correl_fun}? If yes, does \code{B_fun} include a negative regulation?  If difference, stops.
   \item Sum of \code{1/B_fun} need to be equal to 1.
   }
}
\examples{

beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
B <- apply(beta,1,sumbis) 
is.B.accurate(B,3,"CRPos")


}
\seealso{
To verify matrix of co-regulation coefficients, see function \code{\link{is.beta.accurate}}.
}
