% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_builder.R
\docType{class}
\name{SimInf_mparse-class}
\alias{SimInf_mparse-class}
\title{Class \code{"SimInf_mparse"}}
\description{
Class to handle the SimInf mparse data
}
\section{Slots}{

\describe{
  \item{latex}{
    Character vector with the model LaTeX code.
  }
  \item{C_code}{
    Character vector with the model C code.
  }
  \item{G}{
    Dependency graph that indicates the transition rates that need
    to be updated after a given state transition has occured.  A
    non-zero entry in element \code{G[i, i]} indicates that
    transition rate \code{i} needs to be recalculated if the state
    transition \code{j} occurs. Sparse matrix (\eqn{Nt \times Nt})
    of object class \code{"\linkS4class{dgCMatrix}"}, where
    \eqn{Nt} is the number of transitions.
  }
  \item{S}{
    Each column corresponds to a state transition, and execution
    of state transition \code{j} amounts to adding the \code{S[,
    j]} column to the state vector \code{u[, i]} of node \emph{i}
    where the transition occurred. Sparse matrix (\eqn{Nc \times
    Nt}) of object class \code{"\linkS4class{dgCMatrix}"}, where
    \eqn{Nc} is the number of transitions and \eqn{Nt} is the
    number of transitions.
  }
}
}

\keyword{methods}
