% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SEIR.R, R/SIR.R
\docType{methods}
\name{recovered}
\alias{recovered}
\alias{recovered,SEIR-method}
\alias{recovered,SIR-method}
\title{Recovered}
\usage{
recovered(model, ...)

\S4method{recovered}{SEIR}(model, i = NULL, ...)

\S4method{recovered}{SIR}(model, i = NULL, ...)
}
\arguments{
\item{model}{The \code{model} to extract the recovered from}

\item{...}{Additional arguments affecting the measure}

\item{i}{Indices specifying the nodes to include when extracting
the number of recovered. Default is NULL, which includes all nodes.}
}
\description{
Extracts the number of recovered
}
\examples{
## Create an 'SIR' model with 5 nodes and initialize
## it to run over 10 days.
u0 <- data.frame(S = rep(99, 5), I = rep(1, 5), R = rep(0, 5))
model <- SIR(u0 = u0, tspan = 1:10, beta = 0.16, gamma = 0.077)

## Run the model and save the result
result <- run(model, threads = 1, seed = 1)

## Extract the number of recovered individuals in each
## node after each time step in the simulation
recovered(result)

## Extract the number of recovered individuals in the
## first node after each time step in the simulation
recovered(result, i = 1)

## Extract the number of recovered individuals in the
## first and third node after each time step in the simulation
recovered(result, i = c(1, 3))
}
\keyword{methods}
