% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_events.R
\docType{class}
\name{SimInf_events-class}
\alias{SimInf_events-class}
\title{Class \code{"SimInf_events"}}
\description{
Class to hold data for scheduled events to modify the discrete
state of individuals in a node at a pre-defined time t.
}
\section{Slots}{

\describe{
  \item{E}{
    Each row corresponds to one compartment in the model. The
    non-zero entries in a column indicates the compartments to
    include in an event.  For the \emph{exit}, \emph{internal
    transfer} and \emph{external transfer} events, a non-zero
    entry indicate the compartments to sample individuals from.
    For the \emph{enter} event, all individuals enter first
    non-zero compartment. \code{E} is sparse matrix of class
    \code{\linkS4class{dgCMatrix}}.
  }
  \item{N}{
     Determines how individuals in \emph{internal transfer} and
     \emph{external transfer} events are shifted to enter another
     compartment.  Each row corresponds to one compartment in the
     model.  The values in a column are added to the current
     compartment of sampled individuals to specify the destination
     compartment, for example, a value of \code{1} in an entry
     means that sampled individuals in this compartment are moved
     to the next compartment.  Which column to use for each event
     is specified by the \code{shift} vector (see below).
     \code{N} is an integer matrix.
  }
  \item{event}{
    Type of event: 0) \emph{exit}, 1) \emph{enter}, 2)
    \emph{internal transfer}, and 3) \emph{external transfer}.
    Other values are reserved for future event types and not
    supported by the current solvers. Integer vector.
  }
  \item{time}{
    Time of when the event occurs i.e., the event is processed
    when time is reached in the simulation.  \code{time} is an
    integer vector.
  }
  \item{node}{
    The node that the event operates on. Also the source node for
    an \emph{external transfer} event.  Integer vector.
    1 <= \code{node[i]} <= Number of nodes.
  }
  \item{dest}{
    The destination node for an \emph{external transfer} event
    i.e., individuals are moved from \code{node} to \code{dest},
    where 1 <= \code{dest[i]} <= Number of nodes.  Set \code{event
    = 0} for the other event types.  \code{dest} is an integer
    vector.
  }
  \item{n}{
    The number of individuals affected by the event. Integer vector.
    n[i] >= 0.
  }
  \item{proportion}{
    If \code{n[i]} equals zero, the number of individuals affected by
    \code{event[i]} is calculated by summing the number of individuls
    with \code{proportion[i]}. Numeric vector.
    0 <= proportion[i] <= 1.
  }
  \item{select}{
    To process \code{event[i]}, the compartments affected by the
    event are specified with \code{select[i]} together with the
    matrix \code{E}, where \code{select[i]} determines which
    column in \code{E} to use.  The specific individuals affected
    by the event are proportionally sampled from the compartments
    corresponding to the non-zero entries in the specified column
    in \code{E[, select[i]]}, where \code{select} is an integer
    vector.
  }
  \item{shift}{
    Determines how individuals in \emph{internal transfer} and
    \emph{external transfer} events are shifted to enter another
    compartment.  The sampled individuals are shifted according to
    column \code{shift[i]} in matrix \code{N} i.e., \code{N[,
    shift[i]]}, where \code{shift} is an integer vector.  See
    above for a description of \code{N}. Unsued for the other
    event types.
  }
}
}

