% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{boxplot,SimInf_model-method}
\alias{boxplot,SimInf_model-method}
\title{Box plot of number of individuals in each compartment}
\usage{
\S4method{boxplot}{SimInf_model}(x, ...)
}
\arguments{
\item{x}{The \code{model} to plot}

\item{...}{Additional arguments affecting the plot produced.}
}
\description{
Produce box-and-whisker plot(s) of the number of individuals in
each model compartment.
}
\examples{
## Create an 'SIR' model with 10 nodes and initialise
## it with 99 susceptible individuals and one infected
## individual. Let the model run over 100 days.
model <- SIR(u0 = data.frame(S = rep(99, 10),
                             I = rep(1, 10),
                             R = rep(0, 10)),
             tspan = 1:100,
             beta = 0.16,
             gamma = 0.077)

## Run the model and save the result.
result <- run(model)

## Create a boxplot
boxplot(result)
}
