% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_weibull.R
\name{analyse_weibull}
\alias{analyse_weibull}
\title{Analyse Dataset with Weibull Regression}
\usage{
analyse_weibull(level = 0.95, alternative = "two.sided")
}
\arguments{
\item{level}{confidence level for CI computation}

\item{alternative}{alternative hypothesis for the tests "two.sided" or "one.sieded"}
}
\value{
an analysis function that returns a data.frame
}
\description{
Analyse Dataset with Weibull Regression
}
\details{
the columns in the return are the two-sided p-value for the test of
equal medians. The estimated medians in the treatment and control group and
the estimated difference in median survival with confidence intervals.

The estimates and tests are comstructed by fitting seperate Weibull
regression models in the treatment and control groups and then estimating
the medians and respective variances with the delta-method.
}
\examples{
condition <- merge(
    assumptions_delayed_effect(),
    design_fixed_followup(),
    by=NULL
  ) |>
  head(3) |>
  tail(1)
dat <- generate_delayed_effect(condition)
analyse_weibull()(condition, dat)
}
