% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_describe.R
\name{analyse_describe}
\alias{analyse_describe}
\alias{summarise_describe}
\title{Create a Function for Descriptive Statistics of a Dataset}
\usage{
analyse_describe()

summarise_describe(name = NULL)
}
\arguments{
\item{name}{name for the summarise function, appended to the name of the analysis method in the final results}
}
\value{
an analyse function that returns a list with the elements
\itemize{
\item \code{followup} follow up time
\item \code{events} table of events vs. treatment
\item \code{ice} if column ice is present, table of intercurrent events, events, treatment
\item \code{subgroup} if column subgroup is present, table of subgroup, events, treatment
}

A function that can be used in Summarise that returns a data frame with
columns with means and standard deviations for every variable in the
description.
}
\description{
Create a Function for Descriptive Statistics of a Dataset
}
\section{Functions}{
\itemize{
\item \code{summarise_describe()}: Summarise Descriptive Statistics

}}
\examples{
condition <- merge(
    assumptions_delayed_effect(),
    design_fixed_followup(),
    by=NULL
  ) |>
  head(1)
dat <- generate_delayed_effect(condition)
analyse_describe()(condition, dat)
condition <- merge(
  assumptions_delayed_effect(),
  design_fixed_followup(),
  by=NULL
) |>
  tail(4) |>
  head(1)

summarise_all <- create_summarise_function(
  describe=summarise_describe()
)

# runs simulations
sim_results <- runSimulation(
  design=condition,
  replications=100,
  generate=generate_delayed_effect,
  analyse=list(
    describe=analyse_describe()
  ),
  summarise = summarise_all
)

# study time is missing, since there was no admin. censoring
sim_results[, 9:16]
}
