% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getfrequency.R
\name{get.freq}
\alias{get.freq}
\title{Calculate the gene(allele) frequency}
\usage{
get.freq(geno, epi.pars, ...)
}
\arguments{
\item{geno}{a dataframe of genotype data: columns are the SNPs; lines are indviduals.}

\item{epi.pars}{a data.frame or a matrix containing the parameter information
 for epistatic effect:
additive  \eqn{\times}{*} additive,
additive  \eqn{\times}{*} dominance,
dominance \eqn{\times}{*} additive, and
dominance \eqn{\times}{*} dominance.}

\item{...}{not used}
}
\value{
a dataframe with allele frequencies (major and minor).
}
\description{
Calculate the gene(allele) frequency for each of the SNPs.
}
\examples{
# genotype file: rows are individuals and columns are SNPs
fgeno.path <- system.file("extdata", "10SNP.txt", package="SimPhe")

# get genotype
geno <- read.geno(fgeno.path, ftype = "snp.head")

get.freq(geno, epistasis.pars)
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de}
}

