% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{eval_surv_base_fun}
\alias{eval_surv_base_fun}
\title{Evaluates the Survival Function without a Marker}
\usage{
eval_surv_base_fun(ti, omega, b_func, gl_dat = get_gl_rule(30L), delta = NULL)
}
\arguments{
\item{ti}{numeric vector with time points.}

\item{omega}{numeric vector with coefficients for the baseline hazard.}

\item{b_func}{basis function for the baseline hazard like \code{\link{poly}}.}

\item{gl_dat}{Gauss–Legendre quadrature data.
See \code{\link{get_gl_rule}}.}

\item{delta}{offset on the log hazard scale. Use \code{NULL} if
there is no effect.}
}
\description{
Evaluates the survival function at given points where the hazard is
given by

\deqn{h(t) = \exp(\vec\omega^\top\vec b(t) + \delta).}
}
\examples{
# Example of a hazard function
b_func <- function(x)
  cbind(1, sin(2 * pi * x), x)
omega <- c(-3, 3, .25)
haz_fun <- function(x)
  exp(drop(b_func(x) \%*\% omega))

plot(haz_fun, xlim = c(0, 10))

# plot the hazard
library(SimSurvNMarker)
gl_dat <- get_gl_rule(60L)
plot(function(x) eval_surv_base_fun(ti = x, omega = omega,
                                    b_func = b_func, gl_dat = gl_dat),
     xlim = c(1e-4, 10), ylim = c(0, 1), bty = "l", xlab = "time",
     ylab = "Survival", yaxs = "i")

# using to few nodes gives a wrong result in this case!
gl_dat <- get_gl_rule(15L)
plot(function(x) eval_surv_base_fun(ti = x, omega = omega,
                                    b_func = b_func, gl_dat = gl_dat),
     xlim = c(1e-4, 10), ylim = c(0, 1), bty = "l", xlab = "time",
     ylab = "Survival", yaxs = "i")
}
