% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agree_reps.R
\name{agree_reps}
\alias{agree_reps}
\title{Tests for Absolute Agreement with Replicates}
\usage{
agree_reps(x, y, id, data, delta, agree.level = 0.95, conf.level = 0.95)
}
\arguments{
\item{x}{Name of column with first measurement}

\item{y}{Name of other column with first measurement}

\item{id}{Column with subject identifier}

\item{data}{Data frame with all data}

\item{delta}{The threshold below which methods agree/can be considered equivalent, can be in any units. Equivalence Bound for Agreement.}

\item{agree.level}{the agreement level required. Default is 95\%. The proportion of data that should lie between the thresholds, for 95\% limits of agreement this should be 0.95.}

\item{conf.level}{the confidence level required. Default is 95\%.}
}
\value{
Returns single list with the results of the agreement analysis.

\describe{
  \item{\code{"loa"}}{a data frame of the limits of agreement including the average difference between the two sets of measurements, the standard deviation of the difference between the two sets of measurements and the lower and upper confidence limits of the difference between the two sets of measurements.}
  \item{\code{"h0_test"}}{Decision from hypothesis test.}
  \item{\code{"identity.plot"}}{Plot of x and y with a line of identity with a linear regression line}
  \item{\code{"bland_alt.plot"}}{Simple Bland-Altman plot. Red line are the upper and lower bounds for shieh test; grey box is the acceptable limits (delta). If the red lines are within the grey box then the shieh test should indicate 'reject h0', or to reject the null hypothesis that this not acceptable agreement between x & y.}
  \item{\code{"ccc.xy"}}{Lin's concordance correlation coefficient and confidence intervals using U-statistics.}
  \item{\code{"conf.level"}}{Returned as input.}
  \item{\code{"agree.level"}}{Returned as input.}

}
}
\description{
agree_nest produces an absolute agreement analysis for data where there is multiple observations per subject but the mean does not vary within subjects as described by Zou (2013). Output mirrors that of agree_test but CCC is calculated via U-statistics.
}
\section{References}{

Zou, G. Y. (2013). Confidence interval estimation for the Bland–Altman limits of agreement with multiple observations per individual. Statistical methods in medical research, 22(6), 630-642.

King, TS and Chinchilli, VM. (2001). A generalized concordance correlation coefficient for continuous and categorical data. Statistics in Medicine, 20, 2131:2147.

King, TS; Chinchilli, VM; Carrasco, JL. (2007). A repeated measures concordance correlation coefficient. Statistics in Medicine, 26, 3095:3113.

Carrasco, JL; Phillips, BR; Puig-Martinez, J; King, TS; Chinchilli, VM. (2013). Estimation of the concordance correlation coefficient for repeated measures using SAS and R. Computer Methods and Programs in Biomedicine, 109, 293-304.
}

\examples{
data('reps')
agree_reps(x = "x", y = "y", id = "id", data = reps, delta = 2)
}
