% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agree_np.R
\name{agree_np}
\alias{agree_np}
\title{Nonparametric Test for Limits of Agreement}
\usage{
agree_np(
  x,
  y,
  id = NULL,
  data,
  delta = NULL,
  prop_bias = FALSE,
  TOST = TRUE,
  agree.level = 0.95,
  conf.level = 0.95
)
}
\arguments{
\item{x}{Name of column with first measurement.}

\item{y}{Name of other column with the other measurement to compare to the first.}

\item{id}{Column with subject identifier with samples are taken in replicates.}

\item{data}{Data frame with all data.}

\item{delta}{The threshold below which methods agree/can be considered equivalent and this argument is required. Equivalence Bound for Agreement or Maximal Allowable Difference.}

\item{prop_bias}{Logical indicator (TRUE/FALSE) of whether proportional bias should be considered for the limits of agreement calculations.}

\item{TOST}{Logical indicator (TRUE/FALSE) of whether to use two one-tailed tests for the limits of agreement. Default is TRUE.}

\item{agree.level}{the agreement level required. Default is 95\%. The proportion of data that should lie between the thresholds, for 95\% limits of agreement this should be 0.95.}

\item{conf.level}{the confidence level required. Default is 95\%.}
}
\value{
Returns simple_agree object with the results of the agreement analysis.
\itemize{
\item \code{loa}: A data frame of the limits of agreement.
\item \code{agree}: A data frame of the binomial proportion of results in agreement.
\item \code{h0_test}: Decision from hypothesis test.
\item \code{qr_mod}: The quantile regression model.
\item \code{call}: The matched call
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{agree_np} A non-parametric approach to limits of agreement.
The hypothesis test is based on binomial proportions within the maximal allowable differences, and the limits are calculated with quantile regression.
}
\section{References}{

Bland, J. M., & Altman, D. G. (1999). Measuring agreement in method comparison studies. In Statistical Methods in Medical Research (Vol. 8, Issue 2, pp. 135–160).
SAGE Publications.
\doi{10.1177/096228029900800204}
}

\examples{
data('reps')
agree_np(x = "x", y = "y", id = "id", data = reps, delta = 2)
}
