% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scap.R
\name{Scap}
\alias{Scap}
\title{Rescaled capillary saturation function}
\usage{
Scap(suc, par.shp, modality = c("uni"), suc.negativ = FALSE)
}
\arguments{
\item{suc}{Suction/pressure heads. Negative if suc.negativ = TRUE}

\item{par.shp}{named parameter in list or vector}

\item{modality}{pore size distribution ('uni' or 'bi')}

\item{suc.negativ}{set TRUE if suction/pressure heads are negative and FALSE if positive}
}
\description{
Rescaled capillary saturation function by Iden and Durner (2014) \cr
}
\details{
\describe{\item{par.shp:}{
alfa [1/L]: van Genuchten shape parameter \cr
n [-]: van Genuchten shape parameter \cr
m [-]: shape parameter (m = 1-(1/n) if missing) \cr
h0 [L]: suction at water content of 0 (i.e. oven dryness) (h0 = 10^6.8 if missing, corresponding to oven dryness at 105°C (Schneider and Goss, 2012))}
\item{}{additional for bimodal ('bi') pore size distribution: \cr
w2 [-]: weigthing between pore space distribution \cr
alfa2 [1/L]: van Genuchten parameter alfa for second pore space distribution \cr
n2 [-]: van Genuchten parameter n for second pore space distribution \cr
m2 [-]: shape parameter (m = 1-(1/n2) if missing) \cr}}

Scap(h) = (Gamma(h)- Gamma(h0))/(1 - Gamma(h0)) \cr
Gamma descripes the capillary saturation function. Here the saturation function of van Genuchten is used: \cr
gamma(h) = (1/(1 + -suc * alfa)^n)^m (see also \code{\link{Sat}})\cr
}
\references{
Iden, S., Durner, W. (2014). Comment to Simple consistent models for water retention and hydraulic conductivity in the complete moisture range by A. Peters. Water Resour. Res. 50, 7530–7534.

Schneider, M., & Goss, K. U. (2012). Prediction of the water sorption isotherm in air dry soils. Geoderma, 170, 64-69.
}
