% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca.R
\name{plot.ca}
\alias{plot.ca}
\title{Distribution plotting}
\usage{
\method{plot}{ca}(x, var, main = NULL, sub = NULL, xlab = NULL,
  ylab = NULL, ...)
}
\arguments{
\item{x}{Output of \code{\link{ca}} command with
\code{interest = "dist"}.}

\item{var}{Name of variable for plotting}

\item{main}{Main title of the plot. Defualt is NULL.}

\item{sub}{Sub title of the plot. Default is NULL.}

\item{xlab}{x-axis label. Default is NULL.}

\item{ylab}{y-axis label. Default is NULL.}

\item{...}{graphics parameters to be passed to the plotting
routines.}
}
\description{
Plots distributions and joint uniform confidence bands of variables in
interest from \code{\link{ca}} command.
}
\examples{
data("mortgage")
### Regression Specification
fm <- deny ~ black + p_irat + hse_inc + ccred + mcred + pubrec +
ltv_med + ltv_high + denpmi + selfemp + single + hischl
### Specify characteristics of interest for plotting
t2 <- "p_irat"
### issue ca command
CAdist <- ca(fm = fm, data = mortgage, var = "black", method = "logit",
t = "p_irat", b = 50, interest = "dist")
### plotting
plot(CAdist, var = "p_irat", ylab = "Prob",
xlab = "Monthly Debt-to-Income Ratio", sub = "logit model")

}
