% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuvieri.R
\docType{data}
\name{cuvieri}
\alias{cuvieri}
\title{Vocalization of the frog \emph{Physalaemus cuvieri}}
\format{
An object of class \code{"Wave"}; see (\code{\link[tuneR]{tuneR}} package).
}
\source{
Original recording housed at Coleção Bioacústica da Universidade Federal de Minas Gerais (CBUFMG-00196). Recorded by Pedro Rocha.
}
\usage{
data(cuvieri)
}
\description{
Recording of a series of three stereotyped calls emitted by a male frog \emph{Physalaemus cuvieri} (Amphibia, Anura, Leptodactylidae). Edited from original \code{".wav"} file for optimal sinal to noise ratio and reduced time duration.
}
\details{
Duration = 1.96 s. Sampling Frequency = 44100 Hz.

Recorded at São José dos Campos Municipality, São Paulo State, Brazil, on 24 September 2013. Air temperature 22ºC.
}
\examples{
data(cuvieri)

seewave::oscillo(cuvieri)
seewave::spectro(cuvieri)
threeDspectro(cuvieri, tlim=c(0, 0.5), flim=c(0, 4), samp.grid=FALSE)
}
\keyword{datasets}
