% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{modules}
\alias{.callingModuleName}
\alias{.callingModuleName,.simList-method}
\alias{currentModule}
\alias{depends}
\alias{depends,.simList-method}
\alias{depends<-}
\alias{depends<-,.simList-method}
\alias{modules}
\alias{modules,.simList-method}
\alias{modules<-}
\alias{modules<-,.simList-method}
\alias{simList-accessors-modules}
\title{Simulation modules and dependencies}
\usage{
modules(object)

\S4method{modules}{.simList}(object)

modules(object) <- value

\S4method{modules}{.simList}(object) <- value

depends(object)

\S4method{depends}{.simList}(object)

depends(object) <- value

\S4method{depends}{.simList}(object) <- value

.callingModuleName(object)

\S4method{.callingModuleName}{.simList}(object)

currentModule(object)
}
\arguments{
\item{object}{A \code{simList} simulation object.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{depends} and \code{modules} slots in a
\code{simList} object.
These are included for advanced users.
\tabular{ll}{
   \code{\link{depends}} \tab List of simulation module dependencies. (advanced) \cr
   \code{\link{modules}} \tab List of simulation modules to be loaded. (advanced) \cr
   \code{\link{inputs}} \tab List of loaded objects used in simulation. (advanced) \cr
}

\code{.callingModuleName} returns the name of the module that is currently
the active module calling functions like \code{scheduleEvent}.
This will only return the module name if it is inside a \code{spades}
function call, i.e., it will return \code{NULL} if used in interactive mode.
The related function \code{currentModule} is simply a rapid accessor for the
current module name. This latter will return the module that is in the current
event queue, which will never be \code{NULL}
}
\details{
Currently, only get and set methods are defined. Subset methods are not.
}
\author{
Alex Chubaty

Eliot McIntire

Eliot McIntire
}
\seealso{
\code{\link{simList-class}},
         \code{\link{simList-accessors-envir}},
         \code{\link{simList-accessors-events}},
         \code{\link{simList-accessors-inout}},
         \code{\link{simList-accessors-objects}},
         \code{\link{simList-accessors-params}},
         \code{\link{simList-accessors-paths}},
         \code{\link{simList-accessors-times}}.
}

